# 项目研发流程选择

> 跑得快还是跑得稳？



大家好，我是鱼皮。

不知道大家是否喜欢吃辣条？反正我是老爱吃了。

吃辣条的时候，我会思考：美味的辣条是如何被制作出来的呢？

为了满足自己的好奇心，我还专门到网上搜了一下，结果大为震惊！

发现有些辣条的制作过程是很 “先进” 的，不是全部靠工人来制作，而是有一条 **生产流水线** 。准备好原材料后，由机器依次完成混合、搅拌、切割、调味、炸制、冷却、包装等操作，而工人只需要监督就行。

![](https://pic.yupi.icu/1/6f6e8ad610e6418e9556fb0fb95afda1.jpeg)

有了这么一套清晰的工序，整个生产辣条的过程就变得井然有序，工人（或机器）只需要一步一步做好自己的事情即可，整体效率更高；而且如果每个环节都经过充分的验证，辣条的质量和安全性也会更高。

这就是 **标准流程** 的重要性。

回到我们今天的主题，如果我们想要开发上线一款产品，也需要有一套标准的研发流程。

所谓的研发流程是指：为了高效完成产品研发，所定制的 **一系列工作步骤和方法** 。团队成员只需依次按照这些步骤和方法来工作，就能够顺利完成高质量的产品。

那么团队在协作开发时，应该定制什么样的研发流程？研发流程的步骤是越多越好，还是越少越好呢？

本篇文章，会结合我自己在大厂工作以及带小团队的经验，依次分享：大厂的标准研发流程、小团队的敏捷研发、以及我们鱼聪明 AI 团队的研发流程选择。希望能帮大家开拓思路，提高团队的项目开发效率和项目质量。



## 大厂的标准研发流程

这是本文分享的重点。

对于大公司，往往会有成百上千人共同参与一个项目。所以为了保证项目稳定推进，大厂的研发流程通常会非常 **完备和复杂** ，包含非常多的步骤，每个步骤的要求也很严格。

我将大厂研发流程的步骤划分为几个阶段，用一张思维导图来概括，会更清晰一些：

![大厂研发流程思维导图](https://pic.yupi.icu/1/3334dda0-2177-4816-bc91-94e7d3b77bde.png)

如果用生产辣条来比喻研发项目。那么大公司研发项目的流程，就像是我开头提到的用 **标准流水线** 生产辣条的流程。

> 注意，以上阶段并不是完全按从上到下的顺序执行，阶段间可能存在交叉，比如技术预研和技术选型其实在设计阶段就应该考虑。



### 需求阶段

需求阶段的目标是：明确我们为什么要做产品？要做一个什么样的产品？产品要有哪些功能？

现在，假设辣条就是我们要做的产品。

由于需求阶段是研发流程中 **最开始** 的环节，我会详细地分为 4 个子阶段来介绍。



#### 需求产生

我们为什么要做辣条呢？可能是进行了市场调研后，发现大家都爱吃辣条、做辣条能发财；可能是无意中发现了一种改进辣条口味的想法；可能是发现我们的资源很适合去生产辣条等等。

需求产生阶段，最重要的事就是尽可能多地收集整理需求，不要放过可能的机会。

有时，可能一个不经意的想法，就是一个很有意义的需求。



#### 需求评审

收集了很多需求后，我们要对需求进行评审，确定其可行性、成本和收益、需求和风险、以及是否符合我们对产品的定位，而不是什么都做。

就像我们打算生产一款新口味的辣条，需要先调研评估新的口味会不会受到欢迎、能不能制作出来。



#### 需求分析

在对需求进行评审后，我们需要进一步分析需求，把需求细化为产品 **具体的** 功能或特性、或者要完成的工作。

比如想生产一款新口味的辣条，我们要确定辣条的辣度和具体口味、研制新的配方、确保辣条的安全性、给辣条设计新的包装袋等。



#### 排期

通过需求分析明确需求后，我们要进行需求排期。

这个阶段我们要制定生产计划，根据需求的重要程度和所需资源等，来安排完成需求的优先顺序和实现周期。

比如生产辣条时，我们要先花 1 个月研制配方、然后花 3 天采购原材料、花 3 天生产辣条、花 1 天验证安全性，同时花 3 天给辣条设计新的包装袋。



### 设计阶段

设计阶段我们的目标是：提前想清楚我们的产品要怎么做？功能如何实现？

对于生产辣条，设计阶段的目标就是 “确认辣条的配方”。

首先， **架构设计** 就像是确定辣条的主要材料和制作工艺，确保后续可以在此基础上做出多种不同新口味的辣条，而不是每种新口味的配方都从 0 全新调制（可扩展性）。

**概要设计** 是类似于对辣条的整体构思，比如辣椒的种类、辣椒粉和面粉的比例、辣条的大小等。

**详细设计** 是对概要设计的补充完善，深度研究配方中的每种配料的 **细节** 、确定每个步骤的具体要求。比如先放 3 克辣椒粉、再放 100 克面粉、再混合搅拌 3 圈（我瞎编的）。

完成上述设计后，我们要分享自己的设计，和其他团队成员共同讨论，确保大家的 **方案对齐** 、想法完全一致。而不是等到上市后，让不同的用户吃到不同配方的辣条。

在设计阶段，不止需要产品经理和研发工程师，测试同学也要参与进来，提前进行 **测试用例设计** 。定义对辣条进行质量验证的标准，例如具体的辣度在 xx ~ xx 之间、辣条长度为 10 cm 等。



### 研发准备

研发准备阶段，我们要做的是：准备项目研发所需的基础条件。

比如正式生产辣条前，我们要先进行 **技术预研** ，通过查阅资料来提前调研我们实现新口味配方的可行性。然后我们要进行 **技术选型 **，选择使用何种工具或机器来调制配方、切割辣条。

完成技术选型后，还要进行 **资源申请** ，确认团队的资金足够让我们使用先进的工具或机器、购买原材料以及配备工人。

在大公司，资源的申请往往非常严格，像我在腾讯的时候，想要申请 1 台服务器来部署项目，都要经过领导、运维等好几层的审批。

申请到资源后，我们需要进行 **环境准备** ，找一个干净卫生、配备水电的场地来放置辣条生产机器和工人。在研发流程中，环境准备的工作就是搭建开发环境、安装开发必要的软件和工具等。

之后，我们就可以进行 **项目初始化** 和 **依赖安装** ，把机器和工人安排到指定的位置、通水通电、启动机器、安装机器程序等等，让一切准备就绪。在研发流程中，我们可能会使用脚手架之类的工具来自动生成一个干净的项目初始代码，并且使用包管理器安装运行项目所需的基本依赖，接下来就可以愉快地写代码啦！



### 研发阶段

研发阶段是程序员们大显身手的阶段，这个阶段的目标是写代码完成项目。

研发阶段又可以分为：本地开发、远程开发、代码优化、单元测试、开发联调 5 个小阶段。

首先，每位开发者可以在自己的电脑上编写代码（本地开发），也可以选择在同一个公共机上协作开发代码（远程开发）。在开发完成基本功能后，要进行代码优化，比如增加异常处理来提高健壮性、使用多线程来优化性能等。之后，要自己编写基本的单元测试，来验证代码能否正常运行并返回预期结果。最后，程序员们需要相互配合，进行开发联调，即调用彼此的代码来验证完整功能的可用性。

比喻成生产辣条，这个阶段就是由机器和人工相互配合，完成对辣条的搅拌、切割、调味、检验等操作。由于我没有参与过辣条生产，不知道他们是不是还有人工试吃环节，如果发现味道不好，还得修一修机器（程序员改 Bug）、或者再人工加点儿秘料（代码优化）。



### 测试验证

在完成开发后，我们必须进行测试验证，这个阶段的目标就是：确保产品功能的正常运行，消灭 Bug！

有同学可能会问：研发阶段中，程序员不是已经自己编写过单元测试了么？

但是，单元测试只是一个最基本的保证，只能保证自己的代码没有问题；如果多人的代码需要互相调用配合，还需要有更进一步的测试 —— **集成测试** ，来保证大家的代码整合到一起也没有问题。

除了单元测试和集成测试外，比较常见的测试类型还有系统测试、验收测试。

**系统测试** 是在集成测试后，对整个系统进行全面的功能和性能测试，测试的范围更大。

而 **验收测试** 通常是测试的最后一个阶段，确认系统是否满足实际的需求以及用户期望。

这里还有一个概念是 **产品体验** ，是指从真实用户的角度来感受产品功能的优缺点。严格来说，产品体验不只是在测试阶段才进行，而是应该贯穿整个开发过程，便于提前发现问题和改进。

比喻为生产辣条，在我们生产完辣条后，不仅自己要试吃，还要有专业的品尝师来体验、检查辣条的配方和制作是否有问题。



### 提交阶段

提交阶段的目标是：把已经通过测试的本地代码提交、推送到远程仓库，并且合并到主分支，为上线做好准备。

实际开发中，由于项目是由多人维护的，为了减少代码冲突和烂代码，会采用 **代码审查** 机制。想要合并代码到主分支前，必须发起 MR（Merge Request） **合并请求** ，然后由项目的负责人（一般是你的领导或同事）检查你的代码，没问题后才允许合并。

这样一来，所有的代码会经过至少 2 名成员的检查，代码质量会更高，也减少了上线出 Bug 的概率。

比喻为生产辣条，代码审查就好像是由专业的食品卫生机构来检验辣条生产的安全标准，如果发现配方或生产过程有任何的问题，就打回去重做。



### 发布阶段

经过了 “九九八十一难”，我们的项目终于可以发布了！

首先，要把我们生产好的辣条进行打包，变成可以售卖的包装袋。然后并不是一开始就做大规模的宣传推广，而是先给一部分顾客试吃，让他们给出一些评价。如果大家对辣条赞不绝口，那么才可以将辣条正式上市，走向大众。

在研发过程中，我们也要对开发完成的代码进行 **打包构建** 。然后先进行 **预发布** （或者灰度发布），给一部分用户进行体验；确认没有问题后，再 **正式上线** 。



### 后续

至此，我们的研发流程还没有结束！只能说是完成了一轮上线而已。

产品上线后，我们还需要持续收集和接受用户的反馈意见，并且对用户的评价进行统计分析，从而不断地优化迭代我们的产品。

此外，文档沉淀也是非常重要的，要把我们这次研发流程中遇到的种种问题、资料、知识全部记录下来，便于团队继续改进。



---



怎么样，感觉大厂的研发流程是不是很复杂？

事实上，完成第一次上线后，每当我们需要给产品增加新功能时，都要完整经历一遍上述流程！甚至有的时候，光需求评审这一个步骤就要经历 1 - 2 个星期的讨论！

这种研发流程虽然能够保证项目的质量，但未必适合小团队，尤其是对于创业公司来说，时间就是金钱。

所以下面再分享一下适合小团队的研发流程 —— 敏捷开发。



## 小团队的敏捷研发

如果说上述大公司的研发流程更注重 **规范和稳定** ，那么敏捷开发更注重 **团队协作和快速迭代** 。

在敏捷开发中，上述大厂研发流程的很多步骤都是可以简化、甚至省略的，非常灵活。

比如上午我们想做一个产品，中午团队成员一起开会讨论需求、并确认产品上线必做的核心功能，下午就直接开始研发写代码了。先用最快的速度完成核心功能、能用就行，然后再持续地讨论新需求、持续地开发和上线、改进产品。

把更多的时间都投入在研发上，主打一个快！

![敏捷开发流程](https://pic.yupi.icu/1/image-20230712185656368.png)

如果采用敏捷研发的方式来生产辣条，大概是这样的：

我们团队发现某个地区的人非常爱吃辣条，那么就直接纯人工用辛勤的双手先做个几包，以最快的速度让这些人试吃；然后再根据这些人的反馈去改良我们的配方、升级我们的包装；等大卖之后，再引进机器、买工厂，批量自动化生产辣条。

需要注意的是，敏捷开发是一种软件开发方法论，具体的方法不止一种，比如 Scrum、Kanban、极限编程等。但是大致了解其基本概念和适用场景就足够了。



## 研发流程选择

在了解了上述的 2 种研发流程后，我们做项目时应该如何选择呢？

首先要明确一点： **没有绝对好的选择** 。无论哪种研发流程，都有各自的优势，要根据实际情况来选择。

敏捷开发虽然追求极致的快速和灵活，但也需要团队成员之间的高度配合，并且带来的风险也更大。有可能投入了几周的开发时间后才发现做了个没什么用的项目。相对而言，大厂的研发流程虽然需要消耗更多的前期资源和精力，但可以带来更高的产品质量、以及研发进度的稳定性。

那么对于我们鱼聪明 AI 团队来说，是选择跑得快还是跑得稳呢？

答案是：小孩子才做选择，我全都要！

![](https://pic.yupi.icu/1/image-20230712184257231.png)

首先，分析我们自身的实际情况：

1. 我们是一个小团队，没有大公司的资源和基础建设（比如流水线自动构建平台）
2. 我们要做的是 AI 类产品，需要快速上线抢占市场
3. 我们团队的同学全在一间 40 平米的小办公室里，大家可以紧密协作

从这几点来看，我们会明显更倾向于敏捷开发。但是我们在敏捷开发的基础上，保留了大厂标准研发流程中的设计阶段和提交阶段，并且给网站做了完备的监控统计，用于持续改进产品。

完整流程如下：

![](https://pic.yupi.icu/1/image-20230712190738396.png)

我们希望网站开发在追求快速的同时，能够兼顾可扩展性和代码质量。因此，一方面我们在设计阶段投入了更多时间，采用更通用化的架构设计来支撑整个系统（比如使用微服务架构，独立拆分支付中心），从而能够应对未来的业务增长。

另外一方面，在协作开发中，我们使用 Git 来管理代码，并采用简化版的 Git Flow 模型，让每位研发同学都创建属于自己的独立开发分支。等各自的功能开发完成后，由我来负责代码审查，通过后再将代码合并到主分支，从而保证了主分支的稳定。

代码审查界面：

![代码审查](https://pic.yupi.icu/1/image-20230712193216012.png)

有同学可能会问了：为什么把测试验证阶段砍掉了？你们做产品都不测试么？

理想情况下，产品上线前肯定是需要由专门的测试工程师来测试验证的。但现实是，我们团队没有测试工程师！

所以我们的策略是：

1. 首先，前端和后端工程师各自开发和自测功能。在上线前，我会与负责该功能的团队成员一起开会，验证功能是否正常。
2. 其次，问题是无法处理完的，系统也是不断完善的。因此，我们将尽快上线，招募一些内测用户来体验系统并反馈 Bug。

这样一来，我们可以把更多的时间投入到研发上，同时不失去对产品质量的关注和持续改进的机会。



---




研发流程的选择没有绝对的对错，关键是要根据团队的实际情况和项目需求来定制。

记住这几个关键点：

1. 大厂研发流程注重规范和稳定，适合大团队
2. 敏捷开发注重快速迭代，适合小团队
3. 可以结合两者的优势，定制适合自己的流程
4. 要保留核心环节（如设计、代码审查），简化非必要环节
5. 研发流程要持续优化，不断改进

在 Vibe Coding 时代，AI 可以帮你快速完成开发工作，但是一个好的研发流程，可以让团队协作更高效、项目质量更有保障。

加油，找到适合自己的研发流程，让项目跑得又快又稳~




## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
